
rsubmit sy56.spawner9;

libname sbst2 'ais.p1252.$4598.sbst2'; 

	
data sbst2.randomize (rename=(FO_PHONE=PHONE));
	set sbst2.analysis17_final;

	/*SSI Status from SISC*/
	if sisc='' then prior_ssi_status=0; /*No SSI Record*/
		else if sisc in('A','C','E','G','M','S') then prior_ssi_status=1; /*SSI Eligible*/
		else if sisc in('B','L','N','T','U','V','W','X') then prior_ssi_status=2; /*SSI Terminated*/
		else if sisc in('D') then prior_ssi_status=3; /*SSI Denied*/
		else if sisc in('I') then prior_ssi_status=4; /*SSI Ineligible*/
		else if sisc in('P') then prior_ssi_status=5; /*SSI Pending*/
		else if sisc in('Y','Z') then prior_ssi_status=6; /*Non-pay, income or resources*/
		else prior_ssi_status=7;
		/*keep if prior_ssi_status in (0,2,3,4)*/
run;

data sbst2.randomize;
	set sbst2.randomize;
	WHERE( POTENTIAL_MBA = 1 
		/*AND SSI_STATUS = . */
		AND PRIOR_SSI_STATUS IN (0,2,3,4)
		AND SNO_CD = '' 
		AND ADDR_STATE NOT IN ('','AE','AP','GU','MP','PR','VI','AA','FM','AS')
		AND NATIONAL=0
		AND AGE BETWEEN 65 AND 80);

proc sort data=sbst2.randomize out=sbst2.randomize (compress=yes);
	by boan;
run;

	/*Randomly select 400k obs*/
		/*seed chosen from random.org (min=1 max=10,000,000) on 8/9/2017*/
proc surveyselect data=sbst2.randomize
	method=srs n=400000 seed=6423671
	out=sbst2.random_step1 (compress=yes);
run;
endrsubmit;

	/*Note: Mainframe doesn't have version of SAS that allows "groups" option*/
libname sbst2 remote 'ais.p1252.$4598.sbst2' server=sy56.spawner9;
	/*Randomly assign the 400,000 to treatment groups*/
		/*seed chosen from random.org (min=1 max=10,000,000) on 8/9/2017*/
proc surveyselect data=sbst2.random_step1
	seed=8976310 groups=4
	out=sbst2.random_step2 (compress=yes);
run;

rsubmit sy56.spawner9;
libname sbst2 'ais.p1252.$4598.sbst2'; 

	/*Update the original file*/	
data sbst2.random_final (compress=yes); 
	update sbst2.randomize sbst2.random_step2;
	by boan;

	treatment=groupid;
	if treatment=. then treatment=0;
run;

endrsubmit;

